import java.rmi.*;
import java.rmi.registry.*;

/**
 * Classe che mette in escuzione un server del Newsgroup
 * 
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 */
public class TestRunServer1 {
	public static void main(String []argv){
		//Istanziazione degli stream di output
		ShowMessagePrompt show=new ShowMessagePrompt();
		
		RegistryInfo reg=null;
		int IDUniquePortNum;
		String IDUniqueHost;
		NewsgroupServerImpl server_ref;
		
		if(argv.length!=6){
			show.println("Usage: java TestRunServer1 <IDUniquehost> <IDUniqueportNum> " +
						"<serverHost> <firstLevPortNum> <secLevPortNum> <argNews>");
			System.exit(0);
		}
		try{
			//Connessione con il server di nomi univoci
			IDUniqueHost=argv[0];
			IDUniquePortNum=Integer.parseInt(argv[1]);
			String registryURL = "rmi://" +IDUniqueHost+ ":" +IDUniquePortNum+"/IDUnique";
			
			/* recupero riferimento al server IDUnique */
			IIDUnique idUniqueServ=(IIDUnique)Naming.lookup(registryURL);
			show.println("Ottenuto il riferimento al server di nomi univoci" );
			
			//Ottenimento del nome univoco del server da creare
			String curServName=idUniqueServ.nextName("server");
			
			//creazione del RegistryInfo
			reg=new RegistryInfo(Integer.parseInt(argv[3]),Integer.parseInt(argv[4]),argv[2],curServName);
			
			//Preparazione url del server
			registryURL = "rmi://"+reg.getHost()+":"+
						RegistryInfo.secondLevelPortNum+"/"+curServName;
			
			try{
				//Controllo che ci sia gi un server attivo.
				String firstLRegURL="rmi://"+reg.getHost()+":"+
							reg.getFirstLevelPortNumber()+"/"+argv[5];
				Registry rProva=(Registry)Naming.lookup(firstLRegURL);
				//Se riesco a fare la list ho gi un server attivo che ha creato il secondo registro
				String []servers=rProva.list();
				
				//Cerco un server casuale s a cui chiedere la bind
				ChooseServerRandom serv=new ChooseServerRandom(reg);
				IServer s=null;
				int numTry=0;
				do{		
					/* recupero riferimento al server */
					s=(IServer)rProva.lookup(serv.whichServer());
					numTry++;
				}while((s==null)&&(numTry<(servers.length/2+1)));
				
				//Creazione del riferimento al server
				server_ref = new NewsgroupServerImpl(curServName,idUniqueServ,show,
									TestMsg.getMsg(idUniqueServ,show),false);

				//Faccio il binding
				s.bindService(server_ref,reg);
				show.println("Binding avvenuto con successo.");
				show.println("Newsgroup Server ready.");
			}
			catch(Exception e){
				//Non ho gi un server attivo
				//faccio partire i registry
				startRegistry(reg,argv[5]);
				
				//creazione del riferimento al server
				server_ref = new NewsgroupServerImpl(curServName,idUniqueServ,show,
									TestMsg.getMsg(idUniqueServ,show),true);
				
				//Binding del server al registry
				Naming.rebind(registryURL, server_ref);
				show.println("Newsgroup Server ready.");
			}	
			
		}
		catch(Exception e){
			show.println("Exception in TestRunServer1: "+e);
			System.exit(1);
		}
	}//end main
	
	
	/* metodo che verifica se c gi un registry attivo sullhost e porta indicati, e se non c lo crea */
	private static void startRegistry(RegistryInfo r,String servName)throws RemoteException{
		Registry secondaryRegistry=null;
		Registry registry;
		try {
			secondaryRegistry =LocateRegistry.createRegistry(RegistryInfo.secondLevelPortNum);
		}
		catch(RemoteException e){
			System.exit(-1);
		}
		
		try{
			registry = LocateRegistry.getRegistry(r.getHost(),r.getFirstLevelPortNumber());
			
		}
		catch (RemoteException e) {
			registry =LocateRegistry.createRegistry(r.getFirstLevelPortNumber());
		}
		registry.rebind(servName, secondaryRegistry);
	} // end startRegistry
}
